clear; clc;
//Scilab 5.5.2, Ubuntu 16.04 LTS
//Plot a full wave rectified waveform using Fourier series
dt=0.05;A=5;w0=1;//Amplitude=5V
t=20.0/dt +1;//no. of points on x-axis
//regeneration from Fourier coefficients of FWR signal
for n=-10:10
    for m=1:t
        sig1(n+11,m)=((2*A/(%pi*(1-4*n^2)))*exp(-1*%i*n*w0*dt*(m-1)));
end
end
for m=1:t
    sig2=sig1(:,m);
    sig3(m)=sum(sig2);
end
sig=sig3';
t=-10:0.05:10.0;// x-axis defined
plot2d(t,sig)
xlabel('Time')
ylabel('Amplitude')
title('Full-wave rectified signal')
